
#IFDEF __STORY_DEBUG__
	Print _ConstEngine_ & " DevKit " & _ConstBuild_ & " Core / Code / SEQ22 / All-In-One"
	SimpleWait ( )
#ENDIF

Const SEQ_DB_GET = 1
Const SEQ_DB_SET = 2

Const SEQ_DB_POP = 4
Const SEQ_DB_CLR = 8

Type SEQ_Database
	As Long iterator
	As String label, value
	As FB.Image Ptr image
End Type

Dim Shared As SEQ_Database Bogus, Report

With Bogus
	.iterator = -1
	.label = ""
	.value = ""
	.image = 0
End With

Report = Bogus

Dim Shared As String SEQ_Text_Buffer
SEQ_Text_Buffer = ""

Declare Sub __Save ( DB ( Any ) As SEQ_Database, Filename As String = "" )

Declare Sub __Load ( DB ( Any ) As SEQ_Database, Filename As String = "" )

Declare Sub __Set Overload ( DB ( Any ) As SEQ_Database, PIndex AS Long = 0, Label As String = "", Value As String = "")

Declare Sub __Set Overload ( DB ( Any ) As SEQ_Database, PIndex AS Long = 0, Label As String = "", Value As Long = 0 )

Declare Sub __Set Overload ( DB ( Any ) As SEQ_Database, PIndex AS Long = 0, Label As String = "", Value As FB.Image Ptr )

Declare Function __Get ( DB ( Any ) As SEQ_Database, Label As String = "" ) As SEQ_Database

Declare Function SEQ_Get ( DB ( Any ) As SEQ_Database, Label As String = "" ) As SEQ_Database

Declare Function SEQ_Set ( DB ( Any ) As SEQ_Database, Label As String = "", Value As String = "" ) As SEQ_Database

Declare Sub SEQ_Inc_Capacity ( DB ( Any ) As SEQ_Database, Counter As Long = 1 )

Declare Function SEQ_DB_CRLF_Buffer ( Buffer As String = "" ) As String

Declare Sub SEQ_Digest_Word ( DB ( Any ) As SEQ_Database, Buffer As String = "" )

Declare Sub SEQ_Show_Array_Direct ( DB ( Any ) As SEQ_Database )

Declare Sub SEQ_Show_Array_Bounds ( DB ( Any ) As SEQ_Database )

Declare Sub SEQ_Show_Array ( DB ( Any ) As SEQ_Database, ByRef Buff As String = "", ByRef Image As FB.Image Ptr = 0 )

Declare Sub SEQ_Bubble_Sort ( DB ( Any ) As SEQ_Database )

Declare Sub __Sort ( DB ( Any ) As SEQ_Database )

Declare Function SEQ_Binary_Find ( DB ( Any ) As SEQ_Database, sName As String = "", ByRef WhereToAdd As Long = 0 ) As Long

Declare Function SEQ_Database_Query ( DB ( Any ) As SEQ_Database, sName As String = "" ) As SEQ_Database

Declare Function SEQ_Database_Set ( DB ( Any ) As SEQ_Database, sName As String = "", sValue As String = "" ) As Long

Declare Function SEQ_Database_Delete ( DB ( Any ) As SEQ_Database, sName As String = "" ) As Long

	Declare Sub SEQ_Database_Save ( DB ( Any ) As SEQ_Database, filename As String = "" )

	Declare Sub SEQ_Database_Load ( DB ( Any ) As SEQ_Database, filename As String = "" )
	
Declare Function SEQ_Database_Export ( DB ( Any ) As SEQ_Database, Buffer As String = "" ) As String

Declare Sub SEQ_Database_Import ( DB ( Any ) As SEQ_Database, Buffer As String = "" )
	
	Declare Sub SEQ_Save_Raw_Buffer ( Buffer As String = "", filename As String = "" )

	Declare Sub SEQ_Load_Raw_Buffer ( Buffer As String = "", filename As String = "")

Declare Function __Buffer ( ShortPath As String = "", ShortFilename As String = "" ) As String

Declare Sub __Set_Wait ( Index As Long = 0, Message As String = "", Value As String = "" ) 

Declare Function __Direct_Buffer ( FullFilename As String = "" ) As String

Sub __Set Overload ( DB ( Any ) As SEQ_Database, PIndex AS Long = 0, Label As String = "", Value As String = "" )
	
	__Set_Wait ( PIndex, Str_Replace ( VARSEP, SP & VARSEP & SP, Label ), Value )

	/' [!] The following line is broken somehow [!] '/
	'''''SEQ_Database_Set ( DB ( ), PageIndex ( PIndex ) & VARSEP & Label, Value )
	
End Sub

Sub __Set Overload ( DB ( Any ) As SEQ_Database, PIndex AS Long = 0, Label As String = "", Value As Long = 0 )

	__Set ( DB ( ), PIndex, Label, Str ( Value ) )
	
End Sub

Sub __Set Overload ( DB ( Any ) As SEQ_Database, PIndex AS Long = 0, Label As String = "", Value As FB.Image Ptr )

	__Set ( DB ( ), PIndex, Label, Str ( @Value ) )
	
End Sub

Function __Get ( DB ( Any ) As SEQ_Database, Label As String = "" ) As SEQ_Database
	Return SEQ_Get ( DB ( ), Label )
End Function

Sub __Save ( DB ( Any ) As SEQ_Database, ShortFilename As String = "" )

	SEQ_Database_Save ( DB ( ), _ConstIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\Seq\" & ShortFilename & ".seq" )

End Sub

Sub __Load ( DB ( Any ) As SEQ_Database, ShortFilename As String = "" )

	SEQ_Database_Load ( DB ( ), _ConstIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\Seq\" & ShortFilename & ".seq" )

End Sub

Function SEQ_Get ( DB ( Any ) As SEQ_Database, Label As String = "" ) As SEQ_Database

	Dim As SEQ_Database Request
	
	With Request
		
		.label = Label
		Request = SEQ_Database_Query ( DB ( ), .label )
	
	End With
	
	Return Request
	
End Function

Function SEQ_Set ( DB ( Any ) As SEQ_Database, Label As String = "", Value As String = "" ) As SEQ_Database

	Dim As SEQ_Database Request
	
	With Request
		
		.label = Label
		.value = Value
		
		.iterator = SEQ_Database_Set ( DB ( ), .label , .value )
		
		.value = DB ( .iterator ) .value
		.image = DB ( .iterator ) .image
	
	End With
	
	Return Request
	
End Function



Sub SEQ_Inc_Capacity ( DB ( Any ) As SEQ_Database, Counter As Long = 1 )

	Select Case Counter
	Case Is > 0
	
		Do While Counter > 0
			
			If UBound ( DB, 1 ) = -1 Then
				ReDim DB ( 0 To 0 )
			Else
				ReDim Preserve DB ( 0 To UBound( DB, 1 ) + 1 )
			End If
			
			Counter -= 1
			
		Loop
		
	Case Is < 0
	
		Do While Counter < 0
			
			If UBound( DB, 1 ) = 0 Then

				ReDim DB ( -1 To -1 )
				
				Exit Do
				
			Else
				
				Redim Preserve DB ( 0 To UBound( DB, 1 ) - 1 )
			
			End If
			
			Counter += 1
			
		Loop
		
	End Select
	
End Sub

Function SEQ_DB_CRLF_Buffer ( Buffer As String = "" ) As String

	If Len ( Buffer ) > 0 Then
		Buffer &= CRLF
	End If

	Return Buffer

End Function

Sub SEQ_Erase ( DB ( Any ) As SEQ_Database )

	For Index As Long = UBound ( DB, 1 ) To 0 Step -1

		With DB ( Index )
			
			.label = ""
			.value = ""
			.image = ImageDestroy2 ( .image )
			.iterator = -1
		
		End With
		
		If Index > 0 Then
			ReDim Preserve DB ( 0 To Index - 1 )
		Else
			ReDim DB ( -1 To -1 )
		End If
	
	Next Index

End Sub

Sub SEQ_Digest_Word ( DB ( Any ) As SEQ_Database, Buffer As String = "" )

	SEQ_Erase DB ( )
	
	Do While Len( Buffer ) > 0
		
		If strpos( CRLF, Buffer ) < strpos( Chr(32), Buffer ) Then
			
			SEQ_Inc_Capacity( DB ( ), 1 )

			With DB( UBound( DB, 1 ) )
				.Iterator = -1
				.label = Hex( UBound( DB, 1 ) + 1 )
				.value = Prefix( CRLF, Buffer )
			End With

			Buffer = Suffix( CRLF, Buffer )

			SEQ_Inc_Capacity( DB ( ), 1 )

			With DB( UBound( DB, 1 ) )
				.Iterator = -1
				.label = Hex( UBound( DB, 1 ) + 1 )
				.value = "{% CRLF %}"
			End With
			
		Else
			
			SEQ_Inc_Capacity( DB ( ), 1 )

			With DB( UBound( DB, 1 ) )
				.Iterator = -1
				.label = Hex( UBound( DB, 1 ) + 1 )
				.value = Prefix( Chr(32), Buffer )
			End With
		
			Buffer = Suffix( Chr(32), Buffer )
		
		End If
		

	Loop
	
	SEQ_Bubble_Sort( DB ( ) )
	
	SEQ_Database_Save( DB ( ), "./Assets (v0x22)/Words.SEQ" )
	
End Sub
	
Sub SEQ_Show_Array_Direct ( DB ( Any ) As SEQ_Database )
	
	Dim As String Buff = ""
	Dim As FB.Image Ptr Image
	
	SEQ_Show_Array ( DB ( ), Buff, Image )
	Buff = "" : Image = ImageDestroy2 ( Image )

End Sub

Sub SEQ_Show_Array_Bounds ( DB ( Any ) As SEQ_Database )
	
	Color RGBA ( 255, 0, 0, 255 )
	Print "LBound:" & SP & QUOT & LBound ( DB, 1 ) & QUOT & SP & "To" & SP & "UBound:" & SP & QUOT & UBound ( DB, 1 ) & QUOT

End Sub

Sub SEQ_Show_Array ( DB ( Any ) As SEQ_Database, ByRef Buff As String = "", ByRef Image As FB.Image Ptr = 0 )
	
	Buff = "" : Image = ImageDestroy2 ( Image )
	
	Dim As String SEQ_Text_Buffer : SEQ_Text_Buffer = ""
	
	For iterator As Long = LBound ( DB, 1 ) To UBound ( DB, 1 ) step 1
		With DB ( iterator )
			SEQ_Text_Buffer &= .label & EQ & .value & CRLF
		End With
	Next
	
	Buff = Text_Box_String ( SEQ_Text_Buffer, 40, 30 )
	Image = Text_Box_Render ( Buff, 40, 30, 0 )
	
	'Color RGBA ( 255, 64, 64, 255 )
	'Print "SEQ Show Array (" & SP & Image -> Width & COMMA & SP & Image -> Height & SP & ")"
	Cls : Put ( 0, 0 ), Image, Alpha : SimpleWait ( )

End Sub

Sub __Sort ( DB ( Any ) As SEQ_Database )
	
	SEQ_Bubble_Sort ( DB ( ) )
	
End Sub

Sub SEQ_Bubble_Sort ( DB ( Any ) As SEQ_Database )

	'Bubble
	
	Do
		Dim As Long Sorted = 0
		For Iterator As Long = LBound ( DB, 1 ) To UBound ( DB, 1 )-1
			If DB ( Iterator ) .label > DB(Iterator+1).label Then
				Swap DB ( Iterator ) .Iterator,DB(Iterator+1).Iterator
				Swap DB(Iterator),DB(Iterator+1)
				Sorted=1
			End If
		Next
		If Sorted = 0 Then Exit Do
	Loop

end sub

Function SEQ_Binary_Find ( DB ( Any ) As SEQ_Database , sName As String = "", ByRef WhereToAdd As Long = 0 ) As Long
	
	'Binary
	
	Dim As Long Lo = LBound ( DB, 1 ), Hi = UBound ( DB, 1 )
	
	While Hi >= Lo		      
		
		Dim As Long Md = ( Lo + Hi + 1 ) \ 2
		Dim As Long Result = strcmp ( sName , DB ( Md ) .label )
		
		select case Result
		case 0
			return Md
		case is > 0			
			Lo = Md + 1
		case else
			Hi = Md - 1
		end select
		
	Wend
	
	WhereToAdd = Lo
	
	return -1

end function

Function SEQ_Database_Query ( DB ( Any ) As SEQ_Database , sName As String = "" ) As SEQ_Database

	var iIndex = SEQ_Binary_Find ( DB ( ) , sName )
	if iIndex >= 0 then return DB( iIndex ) else return Bogus
	
End Function

Function SEQ_Database_Set ( DB ( Any ) As SEQ_Database , sName As String = "" , sValue As String = "" ) As Long

	Dim As Long uNewPos = Any
	
	Var iIndex = SEQ_Binary_Find( DB ( ) , sName , uNewPos )    
	
	If iIndex >= 0 Then 'replace if found
		DB ( iIndex ) .value = sValue
		Return iIndex
	End if
		
	Dim As Long lo = LBound ( DB, 1 ), hi = UBound ( DB, 1 )
	
	If uNewPos <> ( hi + 1 ) Then

		SEQ_Inc_Capacity ( DB ( ), 1 )

		memmove( @DB( uNewPos + 1 ), @DB( uNewPos ), ( ( hi - uNewPos ) - 1 ) *sizeof( DB( 0 ) ) )
		memset( @DB( uNewPos ), 0, sizeof( DB( 0 ) ) )
	
	End If
	
	With DB ( uNewPos )
		.iterator = -1
		.label = sName
		.value = sValue
	End With
	
	return uNewPos    

End function

Function SEQ_Database_Delete ( DB ( Any ) As SEQ_Database , sName As String = "" ) As Long    
	
	var iIndex = SEQ_Binary_Find( DB ( ) , sName )    
	if iIndex<0 then return iIndex 'failed
	with DB(iIndex)
		.label = "" : .value = "" 'clean strings before delete!!
	end with
	var lo = lbound(DB), hi = ubound(DB)    
	memmove( @DB(iIndex), @DB(iIndex+1) , ((hi-iIndex))*sizeof(DB(0)) )
	memset( @DB(hi) , 0 , sizeof(DB(0)) )
	
	lo = LBound ( DB, 1 )
	hi = UBound ( DB, 1 )

	SEQ_Inc_Capacity( DB ( ), -1 )
	
	return iIndex

End function

Sub SEQ_Database_Save ( DB ( Any ) As SEQ_Database, filename As String = "" )
	
	Dim As String Buffer
	Buffer = ""
	
	SEQ_Database_Export( DB ( ), Buffer )
	SEQ_Save_Raw_Buffer( Buffer, filename )

end sub

Sub SEQ_Database_Load ( DB ( Any ) As SEQ_Database, filename As String = "" )
	
	Dim As String Buffer
	Buffer = ""
	
	SEQ_Load_Raw_Buffer( Buffer, filename )
	SEQ_Database_Import( DB ( ), Buffer )

end sub

Function SEQ_Database_Export ( DB ( Any ) As SEQ_Database, Buffer As String = "" ) As String
		
	'Buffer = ""

	SEQ_Bubble_Sort( DB ( ) )
		
	for Iterator As Long = LBound ( DB, 1 ) to UBound ( DB, 1 ) step 1
		
		if DB ( Iterator ) .label <> "" and DB ( Iterator ) .value <> "" then

			if len ( Buffer ) > 0 then
			'if(Iterator > LBound ( DB, 1 )) then
							
				Buffer &= CRLF
			
			end if
						
			Buffer &= DB ( Iterator ) .label & EQ & DB ( Iterator ) .value				
			
		end if
		
	next Iterator
	
	Return Buffer
	
end Function

Sub SEQ_Database_Import ( DB ( Any ) As SEQ_Database, Buffer As String = "" )
	
	Dim As String SEQ_Line
	SEQ_Line = ""
	
	SEQ_Erase DB ( )
	
	While Len( Buffer ) > 0
			
		SEQ_Line = Prefix( CRLF, Buffer )
		Buffer = Suffix( CRLF, Buffer )
			
		If StrPos( EQ, SEQ_Line ) > 0 Then
			
			SEQ_Inc_Capacity( DB ( ), 1 )
		
			With DB( UBound ( DB, 1 ) )
				
				.Iterator = -1
				.label = Prefix( EQ, SEQ_Line )
				.value = Suffix( EQ, SEQ_Line )
				
				Color RGBA ( 63, 255, 63, 255 )
				Print QUOT & .label & QUOT & EQ & QUOT & .value & QUOT
	
				SimpleWait ( )
			
			End With
				
		End If
			
	Wend
		
	SEQ_Bubble_Sort( DB ( ) )
	
end sub		

Sub SEQ_Save_Raw_Buffer ( Buffer As String = "", filename As String = "" )
		
	If Is_File( Filename ) Then
		Kill Filename
	End If

	dim As Long filemode=freefile
				
	if open(filename for binary As #filemode) then
		close #filemode
		exit sub
	end if
		
	put #filemode,lof(filemode)+1,Buffer
				
	close #Filemode
			
end sub

Sub SEQ_Load_Raw_Buffer ( Buffer As String = "", filename As String = "" )

	dim As Long filemode=freefile
	
	if is_file( filename ) then
		
		if open(filename for binary As #filemode) then
			close #filemode
			exit sub
		end if
		
		Buffer = String( lof(filemode), Chr(0) )
		
		If LOF(filemode) > 0 Then
		
			get #filemode, 1, Buffer
		
		End If
		
		close #filemode
				
	end if
	
end sub

Declare function SEQ_Request ( DB ( Any ) as SEQ_Database, Request as SEQ_Database, Mode as Long ) as SEQ_Database

Function SEQ_Request ( DB ( Any ) as SEQ_Database, Request as SEQ_Database, Mode as Long ) as SEQ_Database
	
	dim as Long iterator=-1
	
	select case Mode
	case SEQ_DB_CLR
		
		For Iterator = UBOund ( DB, 1 ) To LBOund ( DB, 1 ) Step -1
			With DB ( Iterator )
				.label = ""
				.value = ""
				.iterator = -1
				.image = ImageDestroy2 ( .image )
			End With
			ReDim Preserve DB ( UBOund ( DB, 1 ) - 1 To LBOund ( DB, 1 ) )
		Next Iterator
		erase DB
		return Bogus
		
	case SEQ_DB_GET			

		With Request
			Request = SEQ_Database_Query ( DB ( ), .label )		
		End With

	case SEQ_DB_POP
	
		With Request
			.Iterator = SEQ_Database_Delete ( DB ( ), .label )
		End With

		return Bogus					

	case SEQ_DB_SET
		
		With Request
			.iterator = SEQ_Database_Set ( DB ( ), .label, .value )
		End With
		
	end select
	
	Return Request
	
End Function

Function __Buffer ( ShortPath As String = "", ShortFilename As String = "" ) As String

	Dim As String Buffer
	Buffer = ""

	Dim As String FullFilename = _ConstIncPathStr_ & Gamepack.Root & Gamepack.Pack & ShortPath & ShortFilename & ".seq"

	Select Case UCWords ( ShortPath )
	Case "", "Page", "/Assets/Page/"
		
		ShortPath = "/Assets/Page/"
		
		FullFilename = _ConstIncPathStr_ & Gamepack.Root & Gamepack.Pack & ShortPath & ShortFilename & ".seq"
		
	Case "Seq", "/Assets/Seq/"
		
		ShortPath = "/Assets/Seq/"
		
		FullFilename = _ConstIncPathStr_ & Gamepack.Root & Gamepack.Pack & ShortPath & ShortFilename & ".seq"
		
	Case Else	
		
		ShortPath = ""
		FullFilename = ShortFilename
		
	End Select
		
	__Buffer = __Direct_Buffer ( FullFilename ) : Return Buffer
	
End Function

Sub __Set_Wait ( Index As Long = 0, Message As String = "", Value As String = "" ) 
	
	SimpleWait ( "__Set_Wait No." & Index & SP & "(" & SP & Message & ":" & SP & QUOT & Value & QUOT & SP & ")", RGBA ( 160, 255, 64, 255 ) )
	
End Sub

Function __Direct_Buffer ( FullFilename As String = "" ) As String
	
	FullFilename = Str_Replace ( "/", "\", FullFilename )

	Dim As String Buffer : Buffer = ""
	
	If Is_File ( FullFilename ) = 0 Then
		SimpleWait ( "Is not a file: " & QUOT & FullFilename & QUOT, RGBA ( 255, 0, 0, 255 ) )
		Buffer = "" : Return Buffer
	End If

	Dim As Long Filemode = Freefile

	If Filemode = 0 Then
		Buffer = "" : Return Buffer
	End If

	If Open ( FullFilename For Binary As #Filemode ) Then
		Close #Filemode
		Filemode = 0
		Buffer = "" : Return Buffer
	End If

	Buffer = Space ( Lof ( Filemode ) )
	Get #Filemode, 1, Buffer
	Close #Filemode
	Filemode = 0
		
	Return Buffer
	
End Function
